<?php
/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       catchplugins.com
 * @since      1.0.0
 *
 * @package    Catch_Instagram_Feed_Gallery_Widget
 * @subpackage Catch_Instagram_Feed_Gallery_Widget/includes
 */

/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Catch_Instagram_Feed_Gallery_Widget
 * @subpackage Catch_Instagram_Feed_Gallery_Widget/includes
 * @author     Catch Plugins <info@catchplugins.com>
 */
class Catch_Instagram_Feed_Gallery_Widget {

	/**
	 * The loader that's responsible for maintaining and registering all hooks that power
	 * the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      Catch_Instagram_Feed_Gallery_Widget_Loader    $loader    Maintains and registers all hooks for the plugin.
	 */
	protected $loader;

	/**
	 * The unique identifier of this plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 *
	 * @since    1.0.0
	 * @access   protected
	 * @var      string    $version    The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 *
	 * Set the plugin name and the plugin version that can be used throughout the plugin.
	 * Load the dependencies, define the locale, and set the hooks for the admin area and
	 * the public-facing side of the site.
	 *
	 * @since    1.0.0
	 */
	public function __construct() {
		if ( defined( 'CATCH_INSTGRAM_FEED_GALLERY_VERSION' ) ) {
			$this->version = CATCH_INSTGRAM_FEED_GALLERY_VERSION;
		} else {
			$this->version = '1.6.1';
		}
		$this->plugin_name = 'catch-instagram-feed-gallery-widget';

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 *
	 * Include the following files that make up the plugin:
	 *
	 * - Catch_Instagram_Feed_Gallery_Widget_Loader. Orchestrates the hooks of the plugin.
	 * - Catch_Instagram_Feed_Gallery_Widget_i18n. Defines internationalization functionality.
	 * - Catch_Instagram_Feed_Gallery_Widget_Admin. Defines all hooks for the admin area.
	 * - Catch_Instagram_Feed_Gallery_Widget_Public. Defines all hooks for the public side of the site.
	 *
	 * Create an instance of the loader which will be used to register the hooks
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {

		/**
		 * The class responsible for orchestrating the actions and filters of the
		 * core plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-catch-instagram-feed-gallery-widget-loader.php';

		/**
		 * The class responsible for defining internationalization functionality
		 * of the plugin.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-catch-instagram-feed-gallery-widget-i18n.php';

		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-catch-instagram-feed-gallery-widget-admin.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-catch-instagram-feed-gallery-widget-public.php';

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-catch-instagram-feed-gallery-widget-helper.php';

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-catch-instagram-feed-gallery-widget-widget.php';

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-catch-instagram-feed-gallery-widget-add-editor-button.php';

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-catch-instagram-feed-gallery-widget-shortcode.php';

		$this->loader = new Catch_Instagram_Feed_Gallery_Widget_Loader();

	}

	/**
	 * Define the locale for this plugin for internationalization.
	 *
	 * Uses the Catch_Instagram_Feed_Gallery_Widget_i18n class in order to set the domain and to register the hook
	 * with WordPress.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function set_locale() {

		$plugin_i18n = new Catch_Instagram_Feed_Gallery_Widget_i18n();

		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );

	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Catch_Instagram_Feed_Gallery_Widget_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );
		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );

		$this->loader->add_action( 'admin_menu', $plugin_admin, 'add_plugin_settings_menu' );

		$this->loader->add_action( 'admin_init', $plugin_admin, 'activation_redirect' );

		if( isset( $_GET['page'] ) && $_GET['page'] === 'catch_instagram_feed_gallery_widget' ){
			$this->loader->add_action( 'admin_notices', $plugin_admin, 'add_settings_errors' );
		}

		$this->loader->add_action( 'wp_ajax_catch_instagram_feed_gallery_widget_update_welcome_panel', $plugin_admin, 'catch_instagram_feed_gallery_widget_admin_ajax_welcome_panel' );

		$this->loader->add_filter( 'plugin_action_links', $plugin_admin, 'action_links', 10, 2 );
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Catch_Instagram_Feed_Gallery_Widget_Public( $this->get_plugin_name(), $this->get_version() );
		$helper = new Catch_Instagram_Feed_Gallery_Widget_Helper;

		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_styles' );
		$this->loader->add_action( 'wp_enqueue_scripts', $plugin_public, 'enqueue_scripts' );
		$this->loader->add_action( 'wp_ajax_load_more', $helper, 'load_more' );
		$this->loader->add_action( 'wp_ajax_nopriv_load_more', $helper, 'load_more' );

	}

	/**
	 * Run the loader to execute all of the hooks with WordPress.
	 *
	 * @since    1.0.0
	 */
	public function run() {
		$this->loader->run();
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * The reference to the class that orchestrates the hooks with the plugin.
	 *
	 * @since     1.0.0
	 * @return    Catch_Instagram_Feed_Gallery_Widget_Loader    Orchestrates the hooks of the plugin.
	 */
	public function get_loader() {
		return $this->loader;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
