(function($){
	$(document).ready( function(){


		var form = new FormData();
		// Just to be sure that the input will be called
		$("#file_upload").on("click", function(){
		  	$('#file_input').click(function(event) {
					event.stopPropagation();
      			});
    		});

		$('#file_input').on('change', prepareUpload);

		function prepareUpload(event) {
			var file = event.target.files;
			var parent = $("#" + event.target.id).parent();
			var formData = new FormData();
			var selectedPage = "photography"
			formData.append("action", "media_file_upload_" + selectedPage);
			$.each(file, function(key, value)
  			{
				formData.append("file", value);
			});

			var count = 0;
			for (var value of formData.values())
			{
				count += 1;
			}

			if (count > 10)
			{
				alert('Only 10 photos per upload.');
				location.reload();
			}
			form = formData;
		}

		$('#submit').click(function(){
			$("#submit").prop('value', 'Uploading....'); 
			var ajaxurl = file_upload.ajax_url;
			$.ajax({
        		url: ajaxurl,
        		type: 'POST',
        		data: form,
        		cache: false,
        		processData: false, // Don't process the files
        		contentType: false, // Set content type to false as jQuery will tell the server its a query string request
        		success: function(data, textStatus, jqXHR) {	
          			location.reload();
        		}
      		});
		});
	});

})(jQuery);