<?php
if ( ! function_exists( 'startkit_typography_customizer' ) ) :
 function startkit_typography_customizer( $wp_customize ) {
$wp_customize->add_panel( 'startkit_typography_setting', array(
		'priority'       => 134,
		'capability'     => 'edit_theme_options',
		'title'      => __('Typography','startkit'),
	) );
	


// Typography Hide/ Show Setting // 

$wp_customize->add_section(
	'typography_setting' ,
		array(
		'title'      => __('Settings','startkit'),
		'panel' => 'startkit_typography_setting',
		'priority'       => 1,
   	) );
	if ( class_exists( 'Startkit_Customizer_Toggle_Control' ) ) {
	$wp_customize->add_setting( 
		'hide_show_typography' , 
			array(
			'default' => 0,
			'capability' => 'edit_theme_options',
		) 
	);
	
	$wp_customize->add_control( new Startkit_Customizer_Toggle_Control( $wp_customize, 
	'hide_show_typography', 
		array(
			'label'	      => esc_html__( 'Enable Typography', 'startkit' ),
			'section'     => 'typography_setting',
			'settings'    => 'hide_show_typography',
			'type'        => 'ios', // light, ios, flat
		) 
	));
	}
	
$font_size = array();
for($i=9; $i<=100; $i++)
{			
	$font_size[$i] = $i;
}
$font_transform = array('lowercase'=>'Lowercase','uppercase'=>'Uppercase','capitalize'=>'capitalize');
$font_weight = array('normal'=>'normal', 'italic'=>'Italic','oblique'=>'oblique');	
// General typography section
$wp_customize->add_section(
	'Body_typography' ,
		array(
		'title'      => __('Body','startkit'),
		'panel' => 'startkit_typography_setting',
		'priority'       => 2,
   	) );
		//Secondary font weight
		
		$wp_customize->add_setting(
			'body_typography_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
		'body_typography_font_weight', array(
				'label' => __('Font Style','spicepress'),
				'section' => 'Body_typography',
				'setting' => 'body_typography_font_weight',
				'choices'=>$font_weight,
				'description'=>__('','startkit'),
			))
		);
		// Body font size// 
		$wp_customize->add_setting( 
			'body_font_size' , 
				array(
				'default' => __( '16','startkit' ),
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'body_font_size', 
			array(
				'section'  => 'Body_typography',
				'settings' => 'body_font_size',
				'label'    => __( 'Font Size','startkit' ),
				'input_attrs' => array(
					'min'    => 10,
					'max'    => 40,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);

// paragraph typography

		$wp_customize->add_section(
			'paragraph_typography' ,
				array(
				'title'      => __('Paragraph','startkit'),
				'panel' => 'startkit_typography_setting',
				'priority'       => 2,
			) );
		//paragraph font weight
		
		$wp_customize->add_setting(
			'para_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
		'para_font_weight', array(
				'label' => __('Font Style','startkit'),
				'section' => 'paragraph_typography',
				'setting' => 'para_font_weight',
				'choices'=>$font_weight,
				'description'=>__('','startkit'),
			))
		);
		
		// paragraph font size// 
		$wp_customize->add_setting( 
			'paragraph_font_size' , 
				array(
				'default' => __( '16','startkit' ),
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'paragraph_font_size', 
			array(
				'section'  => 'paragraph_typography',
				'settings' => 'paragraph_font_size',
				'label'    => __( 'Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 20,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
		// paragraph line height// 
		$wp_customize->add_setting( 
			'paragraph_line_height' , 
				array(
				'default' => __( '16','startkit' ),
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'paragraph_line_height', 
			array(
				'section'  => 'paragraph_typography',
				'settings' => 'paragraph_line_height',
				'label'    => __( 'Line Height(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 60,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);

		
		//H1 typography
		$wp_customize->add_section(
			'H1_typography' ,
				array(
				'title'      => __('H1','startkit'),
				'panel' => 'startkit_typography_setting',
				'priority'       => 3,
			) 
		);
		
		//H1 font weight
		
		$wp_customize->add_setting(
			'h1_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
		'h1_font_weight', array(
				'label' => __('Font Style','startkit'),
				'section' => 'H1_typography',
				'setting' => 'h1_font_weight',
				'choices'=>$font_weight,
				'description'=>__('','startkit'),
			))
		);
		
		// H1 font size// 
		$wp_customize->add_setting( 
			'h1_font_size' , 
				array(
				'default' => '40',
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h1_font_size', 
			array(
				'section'  => 'H1_typography',
				'settings' => 'h1_font_size',
				'label'    => __( 'Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 45,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
		// paragraph line height// 
		$wp_customize->add_setting( 
			'h1_line_height' , 
				array(
				'default' => __( '50','startkit' ),
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h1_line_height', 
			array(
				'section'  => 'H1_typography',
				'settings' => 'h1_line_height',
				'label'    => __( 'Line Height(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 70,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		//H1 text transform
		
		$wp_customize->add_setting( 
			'h1_text_transform' , 
				array(
				'default' => 'lowercase',
				'capability'     => 'edit_theme_options',
			) 
		);

	$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
	'h1_text_transform' , 
		array(
			'label'          => __( 'Text Transform', 'startkit' ),
			'section'        => 'H1_typography',
			'settings'   	 => 'h1_text_transform',
			'choices'        => $font_transform,
		)) 
	);
	
	//H2 typography
		$wp_customize->add_section(
			'H2_typography' ,
				array(
				'title'      => __('H2','startkit'),
				'panel' => 'startkit_typography_setting',
				'priority'       => 3,
			) 
		);
		
		//H2 font weight
		
		$wp_customize->add_setting(
			'h2_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
		'h2_font_weight', array(
				'label' => __('Font Style','startkit'),
				'section' => 'H2_typography',
				'setting' => 'h2_font_weight',
				'choices'=>$font_weight,
				'description'=>__('','startkit'),
			))
		);
		
		// H2 font size// 
		$wp_customize->add_setting( 
			'h2_font_size' , 
				array(
				'default' => __( '36','startkit' ),
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h2_font_size', 
			array(
				'section'  => 'H2_typography',
				'settings' => 'h2_font_size',
				'label'    => __( 'Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 45,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
		// paragraph line height// 
		$wp_customize->add_setting( 
			'h2_line_height' , 
				array(
				'default' => '46',
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h2_line_height', 
			array(
				'section'  => 'H2_typography',
				'settings' => 'h2_line_height',
				'label'    => __( 'Line Height(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 70,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		//H1 text transform
		
		$wp_customize->add_setting( 
			'h2_text_transform' , 
				array(
				'default' => 'lowercase',
				'capability'     => 'edit_theme_options',
			) 
		);

	$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
	'h2_text_transform' , 
		array(
			'label'          => __( 'Text Transform', 'startkit' ),
			'section'        => 'H2_typography',
			'settings'   	 => 'h2_text_transform',
			'choices'        => $font_transform,
		)) 
	);
	
	
	//H3 typography
		$wp_customize->add_section(
			'H3_typography' ,
				array(
				'title'      => __('H3','startkit'),
				'panel' => 'startkit_typography_setting',
				'priority'       => 3,
			) 
		);
		
		//H3 font weight
		
		$wp_customize->add_setting(
			'h3_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
		'h3_font_weight', array(
				'label' => __('Font Style','startkit'),
				'section' => 'H3_typography',
				'setting' => 'h3_font_weight',
				'choices'=>$font_weight,
				'description'=>__('','startkit'),
			))
		);
		
		// H3 font size// 
		$wp_customize->add_setting( 
			'h3_font_size' , 
				array(
				'default' => '24',
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h3_font_size', 
			array(
				'section'  => 'H3_typography',
				'settings' => 'h3_font_size',
				'label'    => __( 'Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 35,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
		//h3 line height// 
		$wp_customize->add_setting( 
			'h3_line_height' , 
				array(
				'default' => '34',
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h3_line_height', 
			array(
				'section'  => 'H3_typography',
				'settings' => 'h3_line_height',
				'label'    => __( 'Line Height(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 50,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		//H3 text transform
		
		$wp_customize->add_setting( 
			'h3_text_transform' , 
				array(
				'default' => 'lowercase',
				'capability'     => 'edit_theme_options',
			) 
		);

	$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
	'h3_text_transform' , 
		array(
			'label'          => __( 'Text Transform', 'startkit' ),
			'section'        => 'H3_typography',
			'settings'   	 => 'h3_text_transform',
			'choices'        => $font_transform,
		)) 
	);
		
//H4 typography
		$wp_customize->add_section(
			'H4_typography' ,
				array(
				'title'      => __('H4','startkit'),
				'panel' => 'startkit_typography_setting',
				'priority'       => 3,
			) 
		);
		
		//H4 font weight
		
		$wp_customize->add_setting(
			'h4_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
		'h4_font_weight', array(
				'label' => __('Font Style','startkit'),
				'section' => 'H4_typography',
				'setting' => 'h4_font_weight',
				'choices'=>$font_weight,
				'description'=>__('','startkit'),
			))
		);
		
		// H4 font size// 
		$wp_customize->add_setting( 
			'h4_font_size' , 
				array(
				'default' => __( '18','startkit' ),
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h4_font_size', 
			array(
				'section'  => 'H4_typography',
				'settings' => 'h4_font_size',
				'label'    => __( 'Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 28,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
		//h3 line height// 
		$wp_customize->add_setting( 
			'h4_line_height' , 
				array(
				'default' => '28',
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h4_line_height', 
			array(
				'section'  => 'H4_typography',
				'settings' => 'h4_line_height',
				'label'    => __( 'Line Height(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 70,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		//H4 text transform
		
		$wp_customize->add_setting( 
			'h4_text_transform' , 
				array(
				'default' => 'lowercase',
				'capability'     => 'edit_theme_options',
			) 
		);

	$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
	'h4_text_transform' , 
		array(
			'label'          => __( 'Text Transform', 'startkit' ),
			'section'        => 'H4_typography',
			'settings'   	 => 'h4_text_transform',
			'choices'        => $font_transform,
		)) 
	);
	
	
	//H5 typography
		$wp_customize->add_section(
			'H5_typography' ,
				array(
				'title'      => __('H5','startkit'),
				'panel' => 'startkit_typography_setting',
				'priority'       => 3,
			) 
		);
		
		//H5 font weight
		
		$wp_customize->add_setting(
			'h5_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
		'h5_font_weight', array(
				'label' => __('Font Style','startkit'),
				'section' => 'H5_typography',
				'setting' => 'h5_font_weight',
				'choices'=>$font_weight,
				'description'=>__('','startkit'),
			))
		);
		
		// H5 font size// 
		$wp_customize->add_setting( 
			'h5_font_size' , 
				array(
				'default' =>  __( '16','startkit' ),
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h5_font_size', 
			array(
				'section'  => 'H5_typography',
				'settings' => 'h5_font_size',
				'label'    => __( 'Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 25,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
		//h5 line height// 
		$wp_customize->add_setting( 
			'h5_line_height' , 
				array(
				'default' => '15',
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h5_line_height', 
			array(
				'section'  => 'H5_typography',
				'settings' => 'h5_line_height',
				'label'    => __( 'Line Height(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 70,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		//H5 text transform
		
		$wp_customize->add_setting( 
			'h5_text_transform' , 
				array(
				'default' => 'lowercase',
				'capability'     => 'edit_theme_options',
			) 
		);

	$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
	'h5_text_transform' , 
		array(
			'label'          => __( 'Text Transform', 'startkit' ),
			'section'        => 'H5_typography',
			'settings'   	 => 'h5_text_transform',
			'choices'        => $font_transform,
		)) 
	);
	
	
	//H6 typography
		$wp_customize->add_section(
			'H6_typography' ,
				array(
				'title'      => __('H6','startkit'),
				'panel' => 'startkit_typography_setting',
				'priority'       => 3,
			) 
		);
		
		//H5 font weight
		
		$wp_customize->add_setting(
			'h6_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
		'h6_font_weight', array(
				'label' => __('Font Style','startkit'),
				'section' => 'H6_typography',
				'setting' => 'h6_font_weight',
				'choices'=>$font_weight,
				'description'=>__('','startkit'),
			))
		);
		
		// H6 font size// 
		$wp_customize->add_setting( 
			'h6_font_size' , 
				array(
				'default' => __( '16','startkit' ),
				'capability'     => 'edit_theme_options',
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h6_font_size', 
			array(
				'section'  => 'H6_typography',
				'settings' => 'h6_font_size',
				'label'    => __( 'Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 25,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
		//h6 line height// 
		$wp_customize->add_setting( 
			'h6_line_height' , 
				array(
				'default' => '26',
				'capability'     => 'edit_theme_options',				
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'h6_line_height', 
			array(
				'section'  => 'H6_typography',
				'settings' => 'h6_line_height',
				'label'    => __( 'Line Height(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 70,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		//H5 text transform
		
		$wp_customize->add_setting( 
			'h6_text_transform' , 
				array(
				'default' => 'lowercase',
				'capability'     => 'edit_theme_options',
			) 
		);

	$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
	'h6_text_transform' , 
		array(
			'label'          => __( 'Text Transform', 'startkit' ),
			'section'        => 'H6_typography',
			'settings'   	 => 'h6_text_transform',
			'choices'        => $font_transform,
		)) 
	);
	

// menu typography section
$wp_customize->add_section(
	'menu_typography' ,
		array(
		'title'      => __('Menus','startkit'),
		'panel' => 'startkit_typography_setting',
		'priority'       => 2,
   	) );
			//menu font weight
		
		$wp_customize->add_setting(
			'menu_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
				'menu_font_weight',
				array(
					'label' => __('Font Style','startkit'),
					'section' => 'menu_typography',
					'setting' => 'menu_font_weight',
					'choices'=>$font_weight,
					'description'=>__('','startkit'),
				))
			);
		
		// menu font size// 
		$wp_customize->add_setting( 
			'menu_font_size' , 
				array(
				'default' =>  __('15','startkit'),
				'capability'     => 'edit_theme_options',
				
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'menu_font_size', 
			array(
				'section'  => 'menu_typography',
				'settings' => 'menu_font_size',
				'label'    => __( 'Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 20,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
		//menu text transform
		
		$wp_customize->add_setting( 
			'menu_text_transform' , 
				array(
				'default' => 'normal',
				'capability'     => 'edit_theme_options',
			) 
		);

	$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
	'menu_text_transform' , 
		array(
			'label'          => __( 'Text Transform', 'startkit' ),
			'section'        => 'menu_typography',
			'settings'   	 => 'menu_text_transform',
			'choices'        => $font_transform,
		)) 
	);
	
// Sections typography section
$wp_customize->add_section(
	'section_typography' ,
		array(
		'title'      => __('Sections','startkit'),
		'panel' => 'startkit_typography_setting',
		'priority'       => 2,
   	) );
	
			//section font weight
		
		$wp_customize->add_setting(
			'section_tit_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
				'section_tit_font_weight',
				array(
					'label' => __(' Title Font Style','startkit'),
					'section' => 'section_typography',
					'setting' => 'section_tit_font_weight',
					'choices'=>$font_weight,
					'description'=>__('','startkit'),
				))
			);
		
		// section title font size// 
		$wp_customize->add_setting( 
			'section_tit_font_size' , 
				array(
				'default' => '36',
				'capability'     => 'edit_theme_options',
				
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'section_tit_font_size', 
			array(
				'section'  => 'section_typography',
				'settings' => 'section_tit_font_size',
				'label'    => __( 'Title Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 50,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
			//section font weight
		
		$wp_customize->add_setting(
			'section_des_font_weight',
			array(
				'default'           =>  'normal',
				'capability'        =>  'edit_theme_options',
				'sanitize_callback' =>  'sanitize_text_field',
			)	
		);
		$wp_customize->add_control(new Cleverfox_Customizer_Select_Control($wp_customize,
				'section_des_font_weight',
				array(
					'label' => __('Description Font Style','startkit'),
					'section' => 'section_typography',
					'setting' => 'section_des_font_weight',
					'choices'=>$font_weight,
					'description'=>__('','startkit'),
				))
			);
		
		// section title font size// 
		$wp_customize->add_setting( 
			'section_desc_font_size' , 
				array(
				'default' => __( '16','startkit' ),
				'capability'     => 'edit_theme_options',
				
			) 
		);

		$wp_customize->add_control( 
		new Cleverfox_Customizer_Range_Slider_Control( $wp_customize, 'section_desc_font_size', 
			array(
				'section'  => 'section_typography',
				'settings' => 'section_desc_font_size',
				'label'    => __( 'Description Font Size(px)','startkit' ),
				'input_attrs' => array(
					'min'    => 1,
					'max'    => 50,
					'step'   => 1,
					//'suffix' => 'px', //optional suffix
				),
			) ) 
		);
		
}
add_action( 'customize_register', 'startkit_typography_customizer' );
endif;
?>